<?php
/*
Plugin Name: Ma Vie De Leader
Description: Plugins Personaliser pour Ma Vie De Leader.
Version: 1.0
Author: Agoralink
Author URI: https://agoralink.fr
*/

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class MVDL
{
    public function __construct()
    {
        $this->init_hooks();
        $this->register_ajax_hooks();
    }

    public function init_hooks()
    {
        add_action('init', [$this, 'register_cpt_etudes_de_cas']);
        add_action('wp_enqueue_scripts', [$this, 'enqueue_assets']);
    }

    public function enqueue_assets()
    {
        // Enqueue CSS file
        wp_enqueue_style(
            'mvdl-style',
            plugin_dir_url(__FILE__) . 'assets/css/style.css',
            [], // Dependencies
            '1.0.0' // Version number
        );

        // Enqueue JS file
        wp_enqueue_script(
            'mvdl-script', // Unique handle for the script
            plugin_dir_url(__FILE__) . 'assets/js/script.js', // Path to the JS file
            ['jquery'],
            '1.0.0',
            true
        );
    }


    public function ajax_get_etude_de_cas()
    {
        // Verify this is an AJAX request
        if (!defined('DOING_AJAX') || !DOING_AJAX) {
            wp_send_json_error(['message' => 'Invalid request']);
        }

//        // Verify the nonce
//        if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'mvdl_nonce')) {
//            wp_send_json_error(['message' => 'Invalid nonce']);
//        }

        // Retrieve the post ID
        $post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : 0;
        if (!$post_id) {
            wp_send_json_error(['message' => 'Invalid post ID']);
        }

        // Fetch the post
        $post = get_post($post_id);
        if (!$post || $post->post_type !== 'etude_de_cas') {
            wp_send_json_error(['message' => 'Post not found or invalid post type']);
        }

        // Send back the title and content
        wp_send_json_success([
            'title' => $post->post_title,
            'content' => apply_filters('the_content', $post->post_content),
        ]);
    }

    public function register_ajax_hooks()
    {
        add_action('wp_ajax_get_etude_de_cas', [$this, 'ajax_get_etude_de_cas']);
        add_action('wp_ajax_nopriv_get_etude_de_cas', [$this, 'ajax_get_etude_de_cas']);
    }

    public function register_cpt_etudes_de_cas()
    {
        $labels = [
            'name' => 'Études de cas',
            'singular_name' => 'Étude de cas',
            'add_new' => 'Ajouter une étude de cas',
            'add_new_item' => 'Ajouter une nouvelle étude de cas',
            'edit_item' => 'Modifier l’étude de cas',
            'new_item' => 'Nouvelle étude de cas',
            'view_item' => 'Voir l’étude de cas',
            'search_items' => 'Rechercher une étude de cas',
            'not_found' => 'Aucune étude de cas trouvée',
            'not_found_in_trash' => 'Aucune étude de cas dans la corbeille',
            'menu_name' => 'Études de cas',
        ];

        $args = [
            'labels' => $labels,
            'public' => true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-portfolio',
            'supports' => ['title', 'editor', 'thumbnail'],
            'show_in_rest' => true, // pour Elementor et Gutenberg
            'rewrite' => ['slug' => 'etudes-de-cas'],
        ];

        register_post_type('etude_de_cas', $args);
    }

}

new MVDL();