jQuery(document).ready(function () {
    jQuery(".select-etude-de-cas").on("change", function () {
        const etudeId = jQuery(this).find(":selected").val();
        console.log("Selected element ID:", etudeId);


        jQuery.ajax({
            url: "/wp-admin/admin-ajax.php",
            method: "POST",
            data: {
                action: "get_etude_de_cas", // AJAX action hooked with wp_ajax_get_etude_de_cas
                post_id: etudeId
            },
            success: function (response) {
                console.log("AJAX response:", response);
                if (response.success) {
                    jQuery("#etude-de-cas-title .elementor-heading-title").text(response.data.title);
                    jQuery("#etude-de-cas-content .elementor-widget-container").html(response.data.content);
                }
            },
            error: function (error) {
                console.error("AJAX error:", error);
            }
        });
        
    });
});